/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Transposer")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Transposer {
    @ZenMethod
    public static void addExtractRecipe(ILiquidStack output, IItemStack input, int energy, @Optional WeightedItemStack itemOut) {
        ItemStack stack = ItemStack.field_190927_a;
        int percent = 0;
        if (itemOut != null) {
            stack = InputHelper.toStack((IItemStack)itemOut.getStack());
            percent = (int)itemOut.getPercent();
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddExtract(InputHelper.toFluid((ILiquidStack)output), InputHelper.toStack((IItemStack)input), energy, stack, percent));
    }

    @ZenMethod
    public static void removeExtractRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveExtract(InputHelper.toStack((IItemStack)input)));
    }

    @ZenMethod
    public static void addFillRecipe(IItemStack output, IItemStack input, ILiquidStack fluid, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFill(InputHelper.toFluid((ILiquidStack)fluid), InputHelper.toStack((IItemStack)input), energy, InputHelper.toStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeFillRecipe(IItemStack input, ILiquidStack fluid) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveFill(InputHelper.toStack((IItemStack)input), InputHelper.toFluid((ILiquidStack)fluid)));
    }

    private static class RemoveFill
    extends BaseAction {
        private ItemStack input;
        private FluidStack fluid;

        public RemoveFill(ItemStack input, FluidStack fluid) {
            super("Transposer Fill");
            this.input = input;
            this.fluid = fluid;
        }

        public void apply() {
            if (!TransposerManager.fillRecipeExists((ItemStack)this.input, (FluidStack)this.fluid)) {
                CraftTweakerAPI.logError((String)("No Transposer Fill recipe exists for: " + this.input));
                return;
            }
            TransposerManager.removeFillRecipe((ItemStack)this.input, (FluidStack)this.fluid);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class AddFill
    extends BaseAction {
        private FluidStack fluid;
        private ItemStack input;
        private int energy;
        private ItemStack output;

        public AddFill(FluidStack output, ItemStack input, int energy, ItemStack itemOut) {
            super("Transposer Fill");
            this.fluid = output;
            this.input = input;
            this.energy = energy;
            this.output = itemOut;
        }

        public void apply() {
            TransposerManager.addFillRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.output, (FluidStack)this.fluid, (boolean)false);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.fluid);
        }
    }

    private static class RemoveExtract
    extends BaseAction {
        private ItemStack input;

        public RemoveExtract(ItemStack input) {
            super("Transposer Extract");
            this.input = input;
        }

        public void apply() {
            if (!TransposerManager.extractRecipeExists((ItemStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Transposer Extraction recipe exists for: " + this.input));
                return;
            }
            TransposerManager.removeExtractRecipe((ItemStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.input);
        }
    }

    private static class AddExtract
    extends BaseAction {
        private FluidStack output;
        private ItemStack input;
        private int energy;
        private ItemStack itemOut;
        private int chance;

        public AddExtract(FluidStack output, ItemStack input, int energy, ItemStack itemOut, int chance) {
            super("Transposer Extract");
            this.output = output;
            this.input = input;
            this.energy = energy;
            this.itemOut = itemOut;
            this.chance = chance;
        }

        public void apply() {
            TransposerManager.addExtractRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.itemOut, (FluidStack)this.output, (int)this.chance, (boolean)false);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

